<?php

add_action( 'widgets_init', 'wplms_instructor_commission_stats_widget' );

function wplms_instructor_commission_stats_widget() {
    register_widget('wplms_instructor_commission_stats');
}

class wplms_instructor_commission_stats extends WP_Widget {


    /** constructor -- name this the same as the class above */
    function __construct() {
      $widget_ops = array( 'classname' => 'wplms_instructor_commission_stats', 'description' => __('WooCommerce Commission Stats  for instructors', 'wplms') );
      $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'wplms_instructor_commission_stats' );
      parent::__construct( 'wplms_instructor_commission_stats', __(' DASHBOARD : Instructor Commission Stats', 'wplms'), $widget_ops, $control_ops );
      add_action('wp_ajax_generate_commission_data',array($this,'generate_commission_data'));

      add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        
      add_filter('vibebp_member_dashboard_widgets',array($this,'add_custom_script'));
    }
    
    function add_custom_script($args){
      $args[]='wplms_instructor_commission_stats';
      return $args;
    }
    
    function enqueue_script(){
        if(is_active_widget(false, false, 'wplms_instructor_commission_stats', true) || apply_filters('vibebp_enqueue_profile_script',false)){

            wp_enqueue_script('wplms_dashboard_instructor_commissions',WPLMS_PLUGIN_URL.'/assets/js/instructor_commissions.js',array('wp-element','wp-data'),WPLMS_DASHBOARD_VERSION,true);
            wp_enqueue_style('wplms_dashboard_css',WPLMS_PLUGIN_URL.'/assets/css/dashboard.css',array(),WPLMS_DASHBOARD_VERSION);
            wp_localize_script('wplms_dashboard_instructor_commissions','instructor_commissions',array(
              'settings'=>array(),
              'api'=>rest_url(BP_COURSE_API_NAMESPACE.'/dashboard/widget'),
              'user_id'  => get_current_user_id(),
              'translations'=>array(
                'earnings'=>__('Earnings','wplms'),
                'payouts'=>__('Payouts','wplms'),
                'no_data'=>__('No data found','wplms'),
                'calculated_commissions' => __('Commissions Calculated','wplms')
              )
            ));
        }
    }
    function widget( $args, $instance ) {
        extract( $args );

        global $wpdb;
        $user_id=get_current_user_id();
        //Our variables from the widget settings.
        $title = apply_filters('widget_title', $instance['title'] );
        $width =  $instance['width'];

        echo '<div class="'.$width.'">
                <div class="dash-widget">'.$before_widget;
        if ( $title )
            echo $before_title . $title . $after_title;

          echo '<div class="wplms_instructor_commission_stats"></div>';

        

        echo '</div>';
        echo $after_widget.'
        </div>';
        return;

    }

    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
	    $instance = $old_instance;
	    $instance['title'] = strip_tags($new_instance['title']);
	    $instance['width'] = $new_instance['width'];
	    return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                        'title'  => __('Instructor Stats','wplms'),
                        'width' => 'col-md-6 col-sm-12'
                    );
  		  $instance = wp_parse_args( (array) $instance, $defaults );
        $title  = esc_attr($instance['title']);
        $width = esc_attr($instance['width']);
        ?>
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
          <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Select Width','wplms'); ?></label> 
          <select id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>">
          	<option value="col-md-3 col-sm-6" <?php selected('col-md-3 col-sm-6',$width); ?>><?php _e('One Fourth','wplms'); ?></option>
          	<option value="col-md-4 col-sm-6" <?php selected('col-md-4 col-sm-6',$width); ?>><?php _e('One Third','wplms'); ?></option>
          	<option value="col-md-6 col-sm-12" <?php selected('col-md-6 col-sm-12',$width); ?>><?php _e('One Half','wplms'); ?></option>
            <option value="col-md-8 col-sm-12" <?php selected('col-md-8 col-sm-12',$width); ?>><?php _e('Two Third','wplms'); ?></option>
             <option value="col-md-8 col-sm-12" <?php selected('col-md-9 col-sm-12',$width); ?>><?php _e('Three Fourth','wplms'); ?></option>
          	<option value="col-md-12" <?php selected('col-md-12',$width); ?>><?php _e('Full','wplms'); ?></option>
          </select>
        </p>
        <?php 
    }
} 

?>