<?php

add_action( 'widgets_init', 'wplms_instructor_dash_stats_widget' );

function wplms_instructor_dash_stats_widget() {
    register_widget('wplms_instructor_dash_stats');
}

class wplms_instructor_dash_stats extends WP_Widget {

    /** constructor -- name this the same as the class above */
    function __construct() {
        $widget_ops = array( 'classname' => 'wplms_instructor_dash_stats', 'description' => __('Simple stats scores for instructors', 'wplms') );
        $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'wplms_instructor_dash_stats' );
        parent::__construct( 'wplms_instructor_dash_stats', __(' DASHBOARD : Instructor Simple Stats', 'wplms'), $widget_ops, $control_ops );

        add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        
    
        add_filter('vibebp_dashboard_widget_custom_script',array($this,'has_custom_script'),10,2);
    
        add_filter('vibebp_member_dashboard_widgets',array($this,'add_custom_script'));
    }
    
    function add_custom_script($args){
      $args[]='wplms_instructor_dash_stats';
      return $args;
    }
    
    function has_custom_script($return,$tag){
        if($tag == 'wplms_instructor_dash_stats'){
            return false;
        }
        return $return;
    }

    function enqueue_script(){
      
        if(is_active_widget(false, false, 'wplms_dash_instructing_modules', true) || apply_filters('vibebp_enqueue_profile_script',false)){

            wp_enqueue_script('wplms_dashboard_instructor_simple_stats',WPLMS_PLUGIN_URL.'/assets/js/instructorsimplestats.js',array('wp-element','wp-data'),WPLMS_DASHBOARD_VERSION,true);
        
            wp_enqueue_style('wplms_dashboard_css',WPLMS_PLUGIN_URL.'/assets/css/dashboard.css',array(),WPLMS_DASHBOARD_VERSION);
            wp_localize_script('wplms_dashboard_instructor_simple_stats','instructorsimplestats',array(
                'settings'=>array(),
                'api'=>rest_url(BP_COURSE_API_NAMESPACE.'/dashboard/widget'),
                
                'translations'=>array(
                )
            ));
        }
    }

    function get_currencies(){
        
        global $wpdb,$bp;
        $commissions = array();
        $results = $wpdb->get_results( "
                                        SELECT meta2.meta_value as currency
                                        FROM  {$bp->activity->table_name_meta} as meta2 
                                        WHERE  meta2.meta_key   LIKE '_currency%'
                                        GROUP BY meta2.meta_value
                                        ",ARRAY_A);
      return $results;
    }
        
    function widget( $args, $instance ) {

        extract( $args );
        //Our variables from the widget settings.
        $title = apply_filters('widget_title', $instance['title'] );
        $width =  $instance['width'];
        $stats =  $instance['stats'];
        $user_id = get_current_user_id();

        
        global $wpdb;
   

        echo '<div class="'.$width.'">
          <div class="dash-widget '.$stats.'">'.$before_widget;
          echo '<div class="instructor_simple_stats" data-type="'.$stats.'"></div>';
          echo $after_widget.'
          </div>
          </div>';    		
        return;
        
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
	    $instance = $old_instance;
	    $instance['title'] = strip_tags($new_instance['title']);
	    $instance['stats'] = $new_instance['stats'];
	    $instance['width'] = $new_instance['width'];
	    return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                        'title'  => __('Instructor Stats','wplms'),
                        'stats' => '',
                        'width' => 'col-md-6 col-sm-12'
                    );
  		  $instance = wp_parse_args( (array) $instance, $defaults );
        $title  = esc_attr($instance['title']);
        $stats = esc_attr($instance['stats']);
        $width = esc_attr($instance['width']);
        ?>
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
        <p>
          <label for="<?php echo $this->get_field_id('stats'); ?>"><?php _e('Select Stats','wplms'); ?>
          </label> 
          <select id="<?php echo $this->get_field_id( 'stats' ); ?>" name="<?php echo $this->get_field_name( 'stats' ); ?>">
          <?php
          $stats_array=apply_filters('wplms_dashboard_instructor_stats',array(
              'woo_commission' => __('WooCommerce Earnings','wplms'),
              'courses' =>__('Number of courses','wplms'),
              'quizes' => __('Number of Quizzes','wplms'),
              'assignments' => __('Number of assignments','wplms'),
              'questions' => __('Number of questions','wplms'),
              'units' => __('Number of units','wplms'),
              'badges' => __('Number of badges','wplms'),
              'certificates' => __('Number of certificates','wplms'),
              'students' => __('Number of Students','wplms'),
            ));
          foreach($stats_array as $key => $value){
            echo '<option value="'.$key.'" '.selected($key,$stats,false).'>'.$value.'</option>';
          }
          ?>
          </select>
        </p>
        <p>
          <label for="<?php echo $this->get_field_id('width'); ?>"><?php _e('Select Width','wplms'); ?></label> 
          <select id="<?php echo $this->get_field_id('width'); ?>" name="<?php echo $this->get_field_name('width'); ?>">
          	<option value="col-md-3 col-sm-6" <?php selected('col-md-3 col-sm-6',$width); ?>><?php _e('One Fourth','wplms'); ?></option>
          	<option value="col-md-4 col-sm-6" <?php selected('col-md-4 col-sm-6',$width); ?>><?php _e('One Third','wplms'); ?></option>
          	<option value="col-md-6 col-sm-12" <?php selected('col-md-6 col-sm-12',$width); ?>><?php _e('One Half','wplms'); ?></option>
            <option value="col-md-8 col-sm-12" <?php selected('col-md-8 col-sm-12',$width); ?>><?php _e('Two Third','wplms'); ?></option>
             <option value="col-md-8 col-sm-12" <?php selected('col-md-9 col-sm-12',$width); ?>><?php _e('Three Fourth','wplms'); ?></option>
          	<option value="col-md-12" <?php selected('col-md-12',$width); ?>><?php _e('Full','wplms'); ?></option>
          </select>
        </p>
        <?php 
    }
} 

?>