<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Wplms_Achievements extends \Elementor\Widget_Base 
{


    public function get_name() {
		return 'wplms_achievements';
	}

	public function get_title() {
		return __( 'Achievements', 'wplms' );
	}

	public function get_icon() {
		return 'vicon vicon-medall';
	}

	public function get_categories() {
		return [ 'wplms' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'wplms' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'achievement_type',
			[
				'label' => __('Achievement Type', 'wplms'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'certificates',
				'options'=>[
					'certificates'=>_x('Certificates','elementor','wplms'),
					'badge'=>_x('Badge','elementor','wplms'),
				]
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __('Style', 'wplms'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'carousel',
				'options'=>[
					'carousel'=>_x('Carousel','elementor','wplms'),
					'grid'=>_x('Grid','elementor','wplms'),
				]
			]
		);

		$this->add_control(
			'row',
			[
				'label' => __('Elements in Row / Elements in Screen', 'wplms'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '25',
				'options'=>[
					'4'=>_x('4 in Row','elementor','wplms'),
					'3'=>_x('3 in Row','elementor','wplms'),
					'2'=>_x('2 in Row','elementor','wplms'),
				]
			]
		);

		$this->add_control(
			'total',
			[
				'label' => __( 'Maximum Elements to show', 'wplms' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 50,
				'step' => 1,
				'default' => 6
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		$shortcode = '[user_achievements type="'.$settings['achievement_type'].'" style="'.$settings['style'].'" row="'.$settings['row'].'" total="'.$settings['total'].'"]';

		echo do_shortcode($shortcode);
	}
}