<?php
/**
 * Load assets for our blocks.
 *
 * @package VibeBP
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Load general assets for our blocks.
 *
 * @since 1.0.0
 */
class VibeBP_Block_Assets {


	/**
	 * This plugin's instance.
	 *
	 * @var VibeBP_Block_Assets
	 */
	private static $instance;

	/**
	 * Registers the plugin.
	 */
	public static function register() {
		if ( null === self::$instance ) {
			self::$instance = new VibeBP_Block_Assets();
		}
	}

	/**
	 * The base URL path (without trailing slash).
	 *
	 * @var string $_url
	 */
	private $_url;

	/**
	 * The plugin version.
	 *
	 * @var string $_version
	 */
	private $_version;

	/**
	 * The plugin version.
	 *
	 * @var string $_slug
	 */
	private $_slug;

	/**
	 * The Constructor.
	 */
	public function __construct() {
		$this->_version = VIBEBP_VERSION;
		$this->_slug    = 'vibebp';
		$this->_url     = untrailingslashit( plugins_url( '/', dirname( __FILE__ ) ) );

		add_action( 'enqueue_block_assets', array( $this, 'block_assets' ) );
		add_action( 'init', array( $this, 'editor_assets' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'frontend_scripts' ) );
		add_action( 'the_post', array( $this, 'frontend_scripts' ) );
	}

	/**
	 * Enqueue block assets for use within Gutenberg.
	 *
	 * @access public
	 */
	public function block_assets() {

		// Styles.
		// wp_enqueue_style(
		// 	$this->_slug . '-frontend',
		// 	VIBEBP_PLUGIN_URL. '/dist/blocks.style.build.css',
		// 	array(),
		// 	$this->_version
		// );
	}

	/**
	 * Enqueue block assets for use within Gutenberg.
	 *
	 * @access public
	 */
	public function editor_assets() {

		// Styles.
		wp_register_style(
			$this->_slug . '-editor',
			VIBEBP_PLUGIN_URL . '/dist/blocks.editor.build.css',
			array(),
			$this->_version
		);

		// Scripts.
		wp_register_script(
			$this->_slug . '-editor',
			VIBEBP_PLUGIN_URL . '/dist/blocks.build.js',
			array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-plugins', 'wp-components', 'wp-edit-post', 'wp-api' ),
			time(),
			true
		);

		$post_id    = filter_input( INPUT_GET, 'post', FILTER_SANITIZE_NUMBER_INT );
		$post_title = get_bloginfo( 'name' ) . ( ( false === $post_id ) ? '' : sprintf( ' - %s', get_the_title( $post_id ) ) );

		/**
		 * Filter the default block email address value
		 *
		 * @param string  $to      Admin email.
		 * @param integer $post_id Current post ID.
		 */
		$email_to = (string) apply_filters( 'vibebp_form_default_email', get_option( 'admin_email' ), $post_id );

		wp_localize_script(
			$this->_slug . '-editor',
			'vibebpBlockData',
			[
				'form' => [
					'adminEmail'   => $email_to,
					'emailSubject' => $post_title,
				],
			]
		);

	}

	/**
	 * Enqueue front-end assets for blocks.
	 *
	 * @access public
	 * @since 1.9.5
	 */
	public function frontend_scripts() {

		// Define where the asset is loaded from.
		$dir = VibeBP_Blocks()->asset_source( 'js' );

		// Define where the vendor asset is loaded from.
		$vendors_dir = VibeBP_Blocks()->asset_source( 'js', 'vendors' );

		// Masonry block.
		if ( has_block( $this->_slug . '/gallery-masonry' ) ) {
			wp_enqueue_script(
				$this->_slug . '-masonry',
				$dir . $this->_slug . '-masonry' . VIBEBP_ASSET_SUFFIX . '.js',
				array( 'jquery', 'masonry', 'imagesloaded' ),
				$this->_version,
				true
			);
		}

		// Carousel block.
		if ( has_block( $this->_slug . '/gallery-carousel' ) ) {
			wp_enqueue_script(
				$this->_slug . '-flickity',
				$vendors_dir . '/flickity' . VIBEBP_ASSET_SUFFIX . '.js',
				array( ),
				$this->_version,
				true
			);
		}

	}

}

VibeBP_Block_Assets::register();
